#include "General.h"
#include "BeaconDeployDetection.h"
#include "engine_tt.h"
#include "engine_io.h"
#include "gmgame.h"

#define CUSTOM_BEACON_DEPLOYED 404040

GameObject* ThinkScript = 0;
int BeaconDeploys[128];

void Console(const char *Format, ...)
{
	char buffer[256];
	va_list va;
	_crt_va_start(va, Format);
	vsnprintf(buffer, 256, Format, va);
	va_end(va);
	Console_Input(buffer);
}

BeaconDeployDetection::BeaconDeployDetection()
{
	RegisterEvent(EVENT_OBJECT_CREATE_HOOK,this);
	RegisterEvent(EVENT_LOAD_LEVEL_HOOK,this);
}

BeaconDeployDetection::~BeaconDeployDetection()
{
	UnregisterEvent(EVENT_OBJECT_CREATE_HOOK,this);
	UnregisterEvent(EVENT_LOAD_LEVEL_HOOK,this);
}

void BeaconDeployDetection::OnObjectCreate(void *data,GameObject *obj)
{
	if (Is_Beacon(obj))
	{
		Commands->Send_Custom_Event(obj, ThinkScript, CUSTOM_BEACON_DEPLOYED, 0, 0.0f);
	}
}

void BeaconDeployDetection::OnLoadLevel()
{
	for (int i = 1; i < 127; i++)
	{
		BeaconDeploys[i] = 0;
	}

	ThinkScript = Commands->Create_Object("Invisible_Object", Vector3(57.461f,-35.307f,0.072f));
	Attach_Script_Once(ThinkScript, "BeaconDeployDetection_Think", "");
}

void BeaconDeployDetection_Think::Timer_Expired(GameObject *obj, int number)
{
	int DeployerID = number;
	BeaconDeploys[DeployerID] = 0;
}

void BeaconDeployDetection_Think::Custom(GameObject *obj, int message, int param, GameObject *sender)
{
	if (message == CUSTOM_BEACON_DEPLOYED)
	{
		if (sender)
		{
			int DeployerID = Get_Player_ID(Get_Beacon_Planter(sender));
			BeaconDeploys[DeployerID]++;
			if (BeaconDeploys[DeployerID] == 1)
			{
				Commands->Start_Timer(obj, this, 30.0f, DeployerID);
			}
			else if (BeaconDeploys[DeployerID] > 5)
			{
				BeaconDeploys[DeployerID] = 0;
				Console("MSG %S might be Beacon deploy sound spamming!", Find_Player(DeployerID)->PlayerName);
			}
		}
	}
}

ScriptRegistrant<BeaconDeployDetection_Think> BeaconDeployDetection_Think_Registrant("BeaconDeployDetection_Think","");

BeaconDeployDetection beaconDeployDetection;

extern "C" __declspec(dllexport) Plugin* Plugin_Init()
{
	return &beaconDeployDetection;
}
